/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.tool.data;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import io.github.fabricators_of_create.porting_lib.tool.ToolAction;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import io.github.fabricators_of_create.porting_lib.tool.loot.CanToolPerformAction;
import io.github.fabricators_of_create.porting_lib.tool.mixin.BuilderAccessor;
import io.github.fabricators_of_create.porting_lib.tool.mixin.InvertedLootItemConditionAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_156;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_186;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_223;
import net.minecraft.class_2405;
import net.minecraft.class_2438;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_58;
import net.minecraft.class_69;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7791;
import net.minecraft.class_7794;
import net.minecraft.class_79;
import net.minecraft.class_8488;
import net.minecraft.class_8489;
import net.minecraft.class_8490;
import net.minecraft.class_8564;

public final class ToolActionsLootTableProvider
extends class_2438 {
    public ToolActionsLootTableProvider(FabricDataOutput packOutput) {
        super((class_7784)packOutput, Set.of(), class_7794.method_46184((class_7784)packOutput).field_11354);
    }

    protected void validate(Map<class_2960, class_52> map, class_58 validationcontext) {
    }

    public List<class_2438.class_7790> getTables() {
        return this.field_11354.stream().map(entry -> new class_2438.class_7790(() -> this.replaceAndFilterChangesOnly((class_7791)entry.comp_1068().get()), entry.comp_1069())).collect(Collectors.toList());
    }

    private class_7791 replaceAndFilterChangesOnly(class_7791 subProvider) {
        return newConsumer -> subProvider.method_10399((resourceLocation, builder) -> {
            if (this.findAndReplaceInLootTableBuilder((class_52.class_53)builder, class_1802.field_8868, ToolActions.SHEARS_DIG)) {
                newConsumer.accept(resourceLocation, builder);
            }
        });
    }

    private boolean findAndReplaceInLootTableBuilder(class_52.class_53 builder, class_1792 from, ToolAction toolAction) {
        List<class_55> lootPools = ((BuilderAccessor)builder).getPools();
        boolean found = false;
        for (class_55 lootPool : lootPools) {
            if (!this.findAndReplaceInLootPool(lootPool, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootPool(class_55 lootPool, class_1792 from, ToolAction toolAction) {
        class_79[] lootEntries = lootPool.field_953;
        class_5341[] lootConditions = lootPool.field_954;
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(class_55.class.getName() + " is missing field f_79023_");
        }
        for (class_79 lootEntry : lootEntries) {
            if (this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) {
                found = true;
            }
            if (!(lootEntry instanceof class_69) || !this.findAndReplaceInParentedLootEntry((class_69)lootEntry, from, toolAction)) continue;
            found = true;
        }
        if (lootConditions == null) {
            throw new IllegalStateException(class_55.class.getName() + " is missing field f_79024_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            class_186 compositeLootItemCondition;
            class_5341 lootCondition = lootConditions[i];
            if (lootCondition instanceof class_223 && this.checkMatchTool((class_223)lootCondition, from)) {
                lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
                found = true;
                continue;
            }
            if (!(lootCondition instanceof class_207)) continue;
            class_5341 invLootCondition = ((InvertedLootItemConditionAccessor)lootCondition).getTerm();
            if (invLootCondition instanceof class_223 && this.checkMatchTool((class_223)invLootCondition, from)) {
                lootConditions[i] = class_207.method_889((class_5341.class_210)CanToolPerformAction.canToolPerformAction(toolAction)).build();
                found = true;
                continue;
            }
            if (!(invLootCondition instanceof class_186) || !this.findAndReplaceInComposite(compositeLootItemCondition = (class_186)invLootCondition, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInParentedLootEntry(class_69 entry, class_1792 from, ToolAction toolAction) {
        class_79[] lootEntries = entry.field_982;
        boolean found = false;
        if (lootEntries == null) {
            throw new IllegalStateException(class_69.class.getName() + " is missing field f_79428_");
        }
        for (class_79 lootEntry : lootEntries) {
            if (!this.findAndReplaceInLootEntry(lootEntry, from, toolAction)) continue;
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInLootEntry(class_79 entry, class_1792 from, ToolAction toolAction) {
        class_5341[] lootConditions = entry.field_988;
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(class_79.class.getName() + " is missing field f_79636_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            class_186 composite;
            class_5341 class_53412 = lootConditions[i];
            if (class_53412 instanceof class_186 && this.findAndReplaceInComposite(composite = (class_186)class_53412, from, toolAction)) {
                found = true;
                continue;
            }
            if (!(lootConditions[i] instanceof class_223) || !this.checkMatchTool((class_223)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
            found = true;
        }
        return found;
    }

    private boolean findAndReplaceInComposite(class_186 alternative, class_1792 from, ToolAction toolAction) {
        class_5341[] lootConditions = alternative.field_1246;
        boolean found = false;
        if (lootConditions == null) {
            throw new IllegalStateException(class_186.class.getName() + " is missing field f_285609_");
        }
        for (int i = 0; i < lootConditions.length; ++i) {
            if (!(lootConditions[i] instanceof class_223) || !this.checkMatchTool((class_223)lootConditions[i], from)) continue;
            lootConditions[i] = CanToolPerformAction.canToolPerformAction(toolAction).build();
            found = true;
        }
        return found;
    }

    private boolean checkMatchTool(class_223 lootCondition, class_1792 expected) {
        class_2073 predicate = lootCondition.field_1298;
        Set items = predicate.field_9644;
        return items != null && items.contains(expected);
    }

    public CompletableFuture<?> method_10319(class_7403 pOutput) {
        final HashMap map = Maps.newHashMap();
        Object2ObjectOpenHashMap map1 = new Object2ObjectOpenHashMap();
        this.getTables().forEach(arg_0 -> ToolActionsLootTableProvider.lambda$run$5((Map)map1, map, arg_0));
        class_58 validationcontext = new class_58(class_173.field_1177, new class_8489(){

            @Nullable
            public <T> T getElement(class_8488<T> p_279283_) {
                return (T)(p_279283_.comp_1474() == class_8490.field_44498 ? (class_52)map.get(p_279283_.comp_1475()) : null);
            }
        });
        this.validate(map, validationcontext);
        Multimap multimap = validationcontext.method_361();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_124446_, p_124447_) -> field_11355.warn("Found validation problem in {}: {}", p_124446_, p_124447_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(lootTableEntry -> {
            class_2960 lootTableId = (class_2960)lootTableEntry.getKey();
            class_52 loottable = (class_52)lootTableEntry.getValue();
            Path path = this.field_39374.method_44107(lootTableId);
            return class_2405.method_10320((class_7403)pOutput, (JsonElement)class_8490.field_44498.method_51203().toJsonTree((Object)loottable), (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    private static /* synthetic */ void lambda$run$5(Map map1, Map map, class_2438.class_7790 entry) {
        ((class_7791)entry.comp_1068().get()).method_10399((key, builder) -> {
            class_2960 id = map1.put(class_8564.method_52171((class_2960)key), key);
            if (id != null) {
                class_156.method_33559((String)("Loot table random sequence seed collision on " + String.valueOf(id) + " and " + String.valueOf(key)));
            }
            builder.method_51883(key);
            if (map.put(key, builder.method_334(entry.comp_1069()).method_338()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(key));
            }
        });
    }
}

